/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.rlan;

import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.snmp.Encrypt;
import ibm.nways.ras.RAS;
import java.util.Hashtable;
import java.util.ResourceBundle;

public class CryptPass {
    private static boolean loggingOn;
    private static String whoiam;
    private static ResourceBundle myResources;
    private static final int RASID = 19;
    private static final int RASSUB = 1031;
    private static final String className = "CryptPass";
    public static final int SEED_LENGTH = 8;
    public static final int SHA1_HASH_LENGTH = 20;
    public static final int DES_KEY_LENGTH = 8;
    public static final int PADDING_LENGTH = 8;
    public static final String SECURITY_DESCRIPTOR = "Security_Descriptor";

    public static OctetString RlanEnc(Object object, JDMWizardInfo jDMWizardInfo, int[] nArray, String string) {
        OctetString octetString;
        Hashtable hashtable = jDMWizardInfo.getItems();
        String string2 = string;
        String string3 = hashtable.get(SECURITY_DESCRIPTOR).toString();
        Integer n = new Integer(string3);
        int n2 = n;
        switch (n2) {
            case 1: {
                octetString = CryptPass.strToMsg(object);
                break;
            }
            case 2: {
                octetString = CryptPass.encryptStr(object, nArray, string2);
                break;
            }
            default: {
                throw new RuntimeException(CryptPass.getNLSString("BoxNotConfigured"));
            }
        }
        return new OctetString(octetString);
    }

    public static OctetString RlanDec(OctetString octetString, JDMWizardInfo jDMWizardInfo, int[] nArray) {
        OctetString octetString2;
        String string = "RlanDec";
        if (RAS.isEnabled(19, 1031)) {
            RAS.trace(19, 1031, className, string, "input to RlanDec= " + octetString.toString());
        }
        Hashtable hashtable = jDMWizardInfo.getItems();
        String string2 = (String)hashtable.get("Scalars.SnmpUserPassword");
        String string3 = hashtable.get(SECURITY_DESCRIPTOR).toString();
        Integer n = new Integer(string3);
        int n2 = n;
        switch (n2) {
            case 1: {
                octetString2 = CryptPass.msgToStr(octetString);
                break;
            }
            case 2: {
                octetString2 = CryptPass.decryptStr(octetString, nArray, string2);
                break;
            }
            default: {
                throw new RuntimeException(CryptPass.getNLSString("BoxNotConfigured"));
            }
        }
        return new OctetString(octetString2);
    }

    static void printBytes(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            System.out.print(byArray[n]);
            System.out.print(' ');
            ++n;
        }
    }

    public static OctetString strToMsg(Object object) {
        int n;
        byte[] byArray;
        if (object instanceof Integer) {
            byArray = new byte[2];
            n = (Integer)object;
            byArray[1] = (byte)(n & 0xFF);
            byArray[0] = (byte)(n >>> 8 & 0xFF);
        } else if (object instanceof String) {
            byArray = ((String)object).getBytes();
        } else if (object instanceof OctetString) {
            byArray = ((OctetString)object).toDisplayString().getBytes();
        } else {
            throw new RuntimeException("Cannot handle this class: " + object.getClass());
        }
        int n2 = byArray.length;
        n = (short)(4 + n2);
        short s = (short)(n % 8);
        if (s != 0) {
            n = (short)(n + (8 - s));
        }
        byte[] byArray2 = new byte[n];
        byArray2[0] = 1;
        byArray2[1] = (byte)(object instanceof Integer ? 2 : 4);
        byArray2[2] = (byte)(n2 >> 8);
        byArray2[3] = (byte)(n2 & 0xFF);
        System.arraycopy(byArray, 0, byArray2, 4, n2);
        return new OctetString(byArray2);
    }

    public static OctetString msgToStr(OctetString octetString) {
        if (octetString.value[0] != 1 || octetString.value[1] != 4) {
            return new OctetString("", true);
        }
        int n = (octetString.value[2] << 8) + octetString.value[3];
        return new OctetString(octetString.value, 4, n);
    }

    public static OctetString desEncrypt(Object object, byte[] byArray, byte[] byArray2) {
        int n;
        byte[] byArray3;
        String string = "desEncrypt";
        if (object instanceof Integer) {
            byArray3 = new byte[2];
            n = (Integer)object;
            byArray3[1] = (byte)(n & 0xFF);
            byArray3[0] = (byte)(n >>> 8 & 0xFF);
        } else if (object instanceof String) {
            byArray3 = ((String)object).getBytes();
        } else if (object instanceof OctetString) {
            byArray3 = ((OctetString)object).toDisplayString().getBytes();
        } else {
            throw new RuntimeException("Cannot handle this class: " + object.getClass());
        }
        int n2 = byArray3.length;
        n = (short)(3 + n2);
        short s = (short)(n % 8);
        if (s != 0) {
            n = (short)(n + (8 - s));
        }
        byte[] byArray4 = new byte[n];
        byArray4[0] = (byte)(object instanceof Integer ? 2 : 4);
        byArray4[1] = (byte)(n2 >> 8);
        byArray4[2] = (byte)(n2 & 0xFF);
        System.arraycopy(byArray3, 0, byArray4, 3, n2);
        byte[] byArray5 = new byte[n];
        try {
            Encrypt.encrypt(true, Encrypt.desKey(true, byArray, 0, 8), byArray2, byArray4, 0, byArray4.length, byArray5, 0);
        }
        catch (Exception exception) {
            RAS.logException(19, 1031, className, string, exception);
        }
        return new OctetString(byArray5);
    }

    public static OctetString desDecrypt(OctetString octetString, byte[] byArray, byte[] byArray2) {
        String string = "desDecrypt";
        byte[] byArray3 = new byte[octetString.value.length + 1];
        try {
            Encrypt.encrypt(false, Encrypt.desKey(false, byArray, 0, 8), byArray2, octetString.value, 0, octetString.value.length, byArray3, 1);
        }
        catch (Exception exception) {
            RAS.logException(19, 1031, className, string, exception);
        }
        if (byArray3[1] != 4) {
            if (RAS.isEnabled(19, 1031)) {
                RAS.trace(19, 1031, className, string, CryptPass.getNLSString("DataTypeNotSupported"));
            }
            return new OctetString("", true);
        }
        byArray3[0] = 1;
        return CryptPass.msgToStr(new OctetString(byArray3));
    }

    public static OctetString encryptStr(Object object, int[] nArray, String string) {
        byte[] byArray = new byte[8];
        Encrypt.random(byArray, 0, 8);
        byte[] byArray2 = Encrypt.pwToKey(string.getBytes());
        byte[] byArray3 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        OctetString octetString = CryptPass.desEncrypt(object, byArray2, byArray);
        int n = 0;
        byte[] byArray4 = new byte[9 + octetString.value.length + (nArray.length << 2) + byArray2.length];
        System.arraycopy(byArray2, 0, byArray4, n, byArray2.length);
        byArray4[n += byArray2.length] = 2;
        System.arraycopy(byArray3, 0, byArray4, ++n, 8);
        System.arraycopy(octetString.value, 0, byArray4, n += 8, octetString.value.length);
        n += octetString.value.length;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = (n2 << 2) + n;
            byArray4[n3] = (byte)(nArray[n2] >>> 24);
            byArray4[n3 + 1] = (byte)(nArray[n2] >>> 16 & 0xFF);
            byArray4[n3 + 2] = (byte)(nArray[n2] >>> 8 & 0xFF);
            byArray4[n3 + 3] = (byte)(nArray[n2] & 0xFF);
            ++n2;
        }
        Encrypt.sign(byArray4, 0, byArray4.length, byArray2, 0);
        byte[] byArray5 = new byte[n];
        System.arraycopy(byArray4, 20, byArray5, 0, n - 20);
        System.arraycopy(byArray2, 0, byArray5, n - 20, 20);
        return new OctetString(byArray5);
    }

    public static OctetString decryptStr(OctetString octetString, int[] nArray, String string) {
        if (octetString.value[0] != 2) {
            return new OctetString("", true);
        }
        byte[] byArray = new byte[8];
        System.arraycopy(octetString.value, 1, byArray, 0, 8);
        byte[] byArray2 = Encrypt.pwToKey(string.getBytes());
        int n = octetString.value.length - 20 + nArray.length * 4 + byArray2.length;
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(octetString.value, 0, byArray3, byArray2.length, octetString.value.length - 20);
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = (n2 << 2) + octetString.value.length - 20 + byArray2.length;
            byArray3[n3] = (byte)(nArray[n2] >>> 24);
            byArray3[n3 + 1] = (byte)(nArray[n2] >>> 16 & 0xFF);
            byArray3[n3 + 2] = (byte)(nArray[n2] >>> 8 & 0xFF);
            byArray3[n3 + 3] = (byte)(nArray[n2] & 0xFF);
            ++n2;
        }
        byte[] byArray4 = new byte[20];
        Encrypt.sign(byArray3, 0, byArray3.length, byArray4, 0);
        int n4 = 0;
        while (n4 < 20) {
            if (octetString.value[n4 + octetString.value.length - 20] != byArray4[n4]) {
                throw new RuntimeException(CryptPass.getNLSString("SignatureError"));
            }
            ++n4;
        }
        return CryptPass.desDecrypt(new OctetString(octetString.value, 9, octetString.value.length - 20 - 1 - 8), byArray2, byArray);
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = myResources.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    static {
        whoiam = "CryptPass: ";
        myResources = ResourceBundle.getBundle("ibm.nways.rlan.RlanResources");
    }

    public static class PassType {
        public static final int NONE = 0;
        public static final int PLAIN = 1;
        public static final int ENCRYPTED = 2;
    }

    public static class DataType {
        public static final int INT = 2;
        public static final int OCTSTR = 4;
    }
}

